/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.util.Vector;

public class BorderCheckTask
implements Runnable {
    private transient Server server = null;

    public BorderCheckTask(Server theServer) {
        this.server = theServer;
    }

    public void run() {
        if (this.server == null) {
            return;
        }
        Player[] players = this.server.getOnlinePlayers();
        for (int i = 0; i < players.length; ++i) {
            BorderData border;
            World world;
            Location loc;
            if (players[i] == null || !players[i].isOnline() || (loc = players[i].getLocation()) == null || (world = loc.getWorld()) == null || (border = Config.Border(world.getName())) == null || border.insideBorder(loc.getX(), loc.getZ(), Config.ShapeRound())) continue;
            Location newLoc = BorderCheckTask.newLocation(players[i], loc, border);
            if (!players[i].isInsideVehicle()) {
                players[i].teleport(newLoc);
            } else {
                Vehicle ride = players[i].getVehicle();
                if (ride != null) {
                    double vertOffset = ride.getLocation().getY() - loc.getY();
                    newLoc.setY(newLoc.getY() + vertOffset);
                    ride.setVelocity(new Vector(0, 0, 0));
                    ride.teleport(newLoc);
                } else {
                    players[i].leaveVehicle();
                    players[i].teleport(newLoc);
                }
            }
            if (!Config.whooshEffect()) continue;
            world.playEffect(loc, Effect.SMOKE, 4);
            world.playEffect(loc, Effect.SMOKE, 4);
            world.playEffect(loc, Effect.EXTINGUISH, 0);
        }
    }

    private static Location newLocation(Player player, Location loc, BorderData border) {
        Location newLoc;
        if (Config.Debug()) {
            Config.LogWarn("Border crossing in \"" + loc.getWorld().getName() + "\". Border " + border.toString());
            Config.LogWarn("Player position X: " + Config.coord.format(loc.getX()) + " Y: " + Config.coord.format(loc.getY()) + " Z: " + Config.coord.format(loc.getZ()));
        }
        if ((newLoc = border.correctedPosition(loc, Config.ShapeRound())) == null) {
            if (Config.Debug()) {
                Config.LogWarn("Target new location unviable, using spawn.");
            }
            newLoc = ((World)player.getServer().getWorlds().get(0)).getSpawnLocation();
        }
        if (Config.Debug()) {
            Config.LogWarn("New position in world \"" + newLoc.getWorld().getName() + "\" at X: " + Config.coord.format(newLoc.getX()) + " Y: " + Config.coord.format(newLoc.getY()) + " Z: " + Config.coord.format(newLoc.getZ()));
        }
        player.sendMessage(ChatColor.RED + Config.Message());
        return newLoc;
    }
}

