/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.Config;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.bukkit.Location;
import org.bukkit.World;

public class BorderData {
    private double x = 0.0;
    private double z = 0.0;
    private int radius = 0;
    private Boolean shapeRound = null;
    private double maxX;
    private double minX;
    private double maxZ;
    private double minZ;
    private double radiusSquared;
    private double DefiniteSquare;
    private static final LinkedHashSet<Integer> safeOpenBlocks = new LinkedHashSet<Integer>(Arrays.asList(0, 6, 8, 9, 27, 28, 31, 32, 37, 38, 39, 40, 50, 55, 59, 63, 64, 65, 66, 68, 69, 70, 71, 72, 75, 76, 77, 78, 83, 90, 93, 94));
    private static final LinkedHashSet<Integer> painfulBlocks = new LinkedHashSet<Integer>(Arrays.asList(10, 11, 51, 81));
    private static final int limTop = 120;
    private static final int limBot = 1;

    public BorderData(double x, double z, int radius) {
        this.setData(x, z, radius, null);
    }

    public BorderData(double x, double z, int radius, Boolean shapeRound) {
        this.setData(x, z, radius, shapeRound);
    }

    public final void setData(double x, double z, int radius, Boolean shapeRound) {
        this.x = x;
        this.z = z;
        this.shapeRound = shapeRound;
        this.setRadius(radius);
    }

    public BorderData copy() {
        return new BorderData(this.x, this.z, this.radius, this.shapeRound);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.maxX = x + (double)this.radius;
        this.minX = x - (double)this.radius;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
        this.maxZ = z + (double)this.radius;
        this.minZ = z - (double)this.radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.maxX = this.x + (double)radius;
        this.minX = this.x - (double)radius;
        this.maxZ = this.z + (double)radius;
        this.minZ = this.z - (double)radius;
        this.radiusSquared = (double)radius * (double)radius;
        this.DefiniteSquare = Math.sqrt(0.5 * this.radiusSquared);
    }

    public Boolean getShape() {
        return this.shapeRound;
    }

    public void setShape(Boolean shapeRound) {
        this.shapeRound = shapeRound;
    }

    public String toString() {
        return "radius " + this.radius + " at X: " + Config.coord.format(this.x) + " Z: " + Config.coord.format(this.z) + (this.shapeRound != null ? " (shape override: " + (this.shapeRound != false ? "round" : "square") + ")" : "");
    }

    public boolean insideBorder(double xLoc, double zLoc, boolean round) {
        if (this.shapeRound != null) {
            round = this.shapeRound;
        }
        if (!round) {
            return !(xLoc < this.minX || xLoc > this.maxX || zLoc < this.minZ || zLoc > this.maxZ);
        }
        double X = Math.abs(this.x - xLoc);
        double Z = Math.abs(this.z - zLoc);
        if (X < this.DefiniteSquare && Z < this.DefiniteSquare) {
            return true;
        }
        if (X >= (double)this.radius || Z >= (double)this.radius) {
            return false;
        }
        return X * X + Z * Z < this.radiusSquared;
    }

    public boolean insideBorder(double xLoc, double zLoc) {
        return this.insideBorder(xLoc, zLoc, Config.ShapeRound());
    }

    public boolean insideBorder(Location loc) {
        return this.insideBorder(loc.getX(), loc.getZ(), Config.ShapeRound());
    }

    public Location correctedPosition(Location loc, boolean round) {
        if (this.shapeRound != null) {
            round = this.shapeRound;
        }
        double xLoc = loc.getX();
        double zLoc = loc.getZ();
        double yLoc = loc.getY();
        if (!round) {
            if (xLoc <= this.minX) {
                xLoc = this.minX + Config.KnockBack();
            } else if (xLoc >= this.maxX) {
                xLoc = this.maxX - Config.KnockBack();
            }
            if (zLoc <= this.minZ) {
                zLoc = this.minZ + Config.KnockBack();
            } else if (zLoc >= this.maxZ) {
                zLoc = this.maxZ - Config.KnockBack();
            }
        } else {
            double vX = xLoc - this.x;
            double vZ = zLoc - this.z;
            double magV = Math.sqrt(vX * vX + vZ * vZ);
            xLoc = this.x + vX / magV * ((double)this.radius - Config.KnockBack());
            zLoc = this.z + vZ / magV * ((double)this.radius - Config.KnockBack());
        }
        yLoc = this.getSafeY(loc.getWorld(), Location.locToBlock((double)xLoc), Location.locToBlock((double)yLoc), Location.locToBlock((double)zLoc));
        if (yLoc == -1.0) {
            return null;
        }
        return new Location(loc.getWorld(), Math.floor(xLoc) + 0.5, yLoc, Math.floor(zLoc) + 0.5, loc.getYaw(), loc.getPitch());
    }

    public Location correctedPosition(Location loc) {
        return this.correctedPosition(loc, Config.ShapeRound());
    }

    private boolean isSafeSpot(World world, int X, int Y, int Z) {
        Integer below = world.getBlockTypeIdAt(X, Y - 1, Z);
        return safeOpenBlocks.contains(world.getBlockTypeIdAt(X, Y, Z)) && safeOpenBlocks.contains(world.getBlockTypeIdAt(X, Y + 1, Z)) && (!safeOpenBlocks.contains(below) || below == 8 || below == 9) && !painfulBlocks.contains(below);
    }

    private double getSafeY(World world, int X, int Y, int Z) {
        int y1 = Y;
        for (int y2 = Y; y1 > 1 || y2 < 120; --y1, ++y2) {
            if (y1 > 1 && this.isSafeSpot(world, X, y1, Z)) {
                return y1;
            }
            if (y2 >= 120 || y2 == y1 || !this.isSafeSpot(world, X, y2, Z)) continue;
            return y2;
        }
        return -1.0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BorderData test = (BorderData)obj;
        return test.x == this.x && test.z == this.z && test.radius == this.radius;
    }

    public int hashCode() {
        return ((int)(this.x * 10.0) << 4) + (int)this.z + (this.radius << 2);
    }
}

