/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import com.wimbli.WorldBorder.BorderCheckTask;
import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.WorldBorder;
import com.wimbli.WorldBorder.WorldFillTask;
import com.wimbli.WorldBorder.WorldTrimTask;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.config.Configuration;
import org.bukkit.util.config.ConfigurationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static WorldBorder plugin;
    private static Configuration cfg;
    private static PermissionHandler Permissions;
    private static final Logger mcLog;
    public static DecimalFormat coord;
    private static int borderTask;
    public static WorldFillTask fillTask;
    public static WorldTrimTask trimTask;
    public static Set<String> movedPlayers;
    private static Runtime rt;
    private static boolean shapeRound;
    private static Map<String, BorderData> borders;
    private static String message;
    private static boolean DEBUG;
    private static double knockBack;
    private static int timerTicks;
    private static boolean whooshEffect;
    private static final String logName = "WorldBorder";
    private static final int currentCfgVersion = 3;

    public static long Now() {
        return System.currentTimeMillis();
    }

    public static void setBorder(String world, BorderData border) {
        borders.put(world, border);
        Config.Log("Border set. " + Config.BorderDescription(world));
        Config.save(true);
    }

    public static void setBorder(String world, int radius, double x, double z, Boolean shapeRound) {
        Config.setBorder(world, new BorderData(x, z, radius, shapeRound));
    }

    public static void setBorder(String world, int radius, double x, double z) {
        BorderData old = Config.Border(world);
        Boolean oldShape = old == null ? null : old.getShape();
        Config.setBorder(world, new BorderData(x, z, radius, oldShape));
    }

    public static void removeBorder(String world) {
        borders.remove(world);
        Config.Log("Removed border for world \"" + world + "\".");
        Config.save(true);
    }

    public static void removeAllBorders() {
        borders.clear();
        Config.Log("Removed all borders for all worlds.");
        Config.save(true);
    }

    public static String BorderDescription(String world) {
        BorderData border = borders.get(world);
        if (border == null) {
            return "No border was found for the world \"" + world + "\".";
        }
        return "World \"" + world + "\" has border " + border.toString();
    }

    public static Set<String> BorderDescriptions() {
        HashSet<String> output = new HashSet<String>();
        Iterator<String> world = borders.keySet().iterator();
        while (world.hasNext()) {
            output.add(Config.BorderDescription(world.next()));
        }
        return output;
    }

    public static BorderData Border(String world) {
        return borders.get(world);
    }

    public static void setMessage(String msg) {
        message = msg;
        Config.Log("Border message is now set to: " + msg);
        Config.save(true);
    }

    public static String Message() {
        return message;
    }

    public static void setShape(boolean round) {
        shapeRound = round;
        Config.Log("Set default border shape to " + (round ? "round" : "square") + ".");
        Config.save(true);
    }

    public static boolean ShapeRound() {
        return shapeRound;
    }

    public static void setDebug(boolean debugMode) {
        DEBUG = debugMode;
        Config.Log("Debug mode " + (DEBUG ? "enabled" : "disabled") + ".");
        Config.save(true);
    }

    public static boolean Debug() {
        return DEBUG;
    }

    public static void setWhooshEffect(boolean enable) {
        whooshEffect = enable;
        Config.Log("\"Whoosh\" knockback effect " + (whooshEffect ? "enabled" : "disabled") + ".");
        Config.save(true);
    }

    public static boolean whooshEffect() {
        return whooshEffect;
    }

    public static void setKnockBack(double numBlocks) {
        knockBack = numBlocks;
        Config.Log("Knockback set to " + knockBack + " blocks inside the border.");
        Config.save(true);
    }

    public static double KnockBack() {
        return knockBack;
    }

    public static void setTimerTicks(int ticks) {
        timerTicks = ticks;
        Config.Log("Timer delay set to " + timerTicks + " tick(s). That is roughly " + timerTicks * 50 + "ms / " + (double)timerTicks * 50.0 / 1000.0 + " seconds.");
        Config.StartBorderTimer();
        Config.save(true);
    }

    public static int TimerTicks() {
        return timerTicks;
    }

    public static void StartBorderTimer() {
        Config.StopBorderTimer();
        borderTask = plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)new BorderCheckTask(plugin.getServer()), (long)timerTicks, (long)timerTicks);
        if (borderTask == -1) {
            Config.LogWarn("Failed to start timed border-checking task! This will prevent the plugin from working. Try restarting Bukkit.");
        }
        Config.LogConfig("Border-checking timed task started.");
    }

    public static void StopBorderTimer() {
        if (borderTask == -1) {
            return;
        }
        plugin.getServer().getScheduler().cancelTask(borderTask);
        borderTask = -1;
        Config.LogConfig("Border-checking timed task stopped.");
    }

    public static void StopFillTask() {
        if (fillTask != null && fillTask.valid()) {
            fillTask.cancel();
        }
    }

    public static void StoreFillTask() {
        Config.save(false, true);
    }

    public static void UnStoreFillTask() {
        Config.save(false);
    }

    public static void RestoreFillTask(String world, int fillDistance, int chunksPerRun, int tickFrequency, int x, int z, int length, int total) {
        fillTask = new WorldFillTask(plugin.getServer(), null, world, fillDistance, chunksPerRun, tickFrequency);
        if (fillTask.valid()) {
            fillTask.continueProgress(x, z, length, total);
            int task = plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)fillTask, 20L, (long)tickFrequency);
            fillTask.setTaskID(task);
        }
    }

    public static void StopTrimTask() {
        if (trimTask != null && trimTask.valid()) {
            trimTask.cancel();
        }
    }

    public static int AvailableMemory() {
        return (int)((rt.maxMemory() - rt.totalMemory() + rt.freeMemory()) / 1024L / 1024L);
    }

    public static void loadPermissions(WorldBorder plugin) {
        if (Permissions != null || plugin == null) {
            return;
        }
        Plugin test = plugin.getServer().getPluginManager().getPlugin("Permissions");
        if (test != null) {
            Permissions = ((Permissions)test).getHandler();
            Config.LogConfig("Will use plugin for permissions: " + ((Permissions)test).getDescription().getFullName());
        } else {
            Config.LogConfig("Permissions plugin not found. Defaulting to Bukkit's built-in SuperPerms system.");
        }
    }

    public static boolean HasPermission(Player player, String request) {
        if (player == null) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        if (Permissions != null && Permissions.permission(player, "worldborder." + request)) {
            return true;
        }
        if (player.hasPermission("worldborder." + request)) {
            return true;
        }
        player.sendMessage("You do not have sufficient permissions.");
        return false;
    }

    public static void Log(Level lvl, String text) {
        mcLog.log(lvl, String.format("[%s] %s", logName, text));
    }

    public static void Log(String text) {
        Config.Log(Level.INFO, text);
    }

    public static void LogWarn(String text) {
        Config.Log(Level.WARNING, text);
    }

    public static void LogConfig(String text) {
        Config.Log(Level.INFO, "[CONFIG] " + text);
    }

    public static void load(WorldBorder master, boolean logIt) {
        ConfigurationNode storedFillTask;
        plugin = master;
        cfg = plugin.getConfiguration();
        int cfgVersion = cfg.getInt("cfg-version", 3);
        message = cfg.getString("message");
        shapeRound = cfg.getBoolean("round-border", true);
        DEBUG = cfg.getBoolean("debug-mode", false);
        whooshEffect = cfg.getBoolean("whoosh-effect", false);
        knockBack = cfg.getDouble("knock-back-dist", 3.0);
        timerTicks = cfg.getInt("timer-delay-ticks", 5);
        Config.LogConfig("Using " + (shapeRound ? "round" : "square") + " border, knockback of " + knockBack + " blocks, and timer delay of " + timerTicks + ".");
        DEBUG = cfg.getBoolean("debug-mode", false);
        Config.StartBorderTimer();
        borders.clear();
        if (message == null || message.isEmpty()) {
            Config.LogConfig("Configuration not present, creating new file.");
            message = "You have reached the edge of this world.";
            Config.save(false);
            return;
        }
        Map worlds = cfg.getNodes("worlds");
        if (worlds != null) {
            for (Map.Entry wdata : worlds.entrySet()) {
                String name = null;
                name = cfgVersion > 1 ? ((String)wdata.getKey()).replace("\u00a8", ".") : ((String)wdata.getKey()).replace("/", ".");
                ConfigurationNode bord = (ConfigurationNode)wdata.getValue();
                Boolean overrideShape = (Boolean)bord.getProperty("shape-round");
                BorderData border = new BorderData(bord.getDouble("x", 0.0), bord.getDouble("z", 0.0), bord.getInt("radius", 0), overrideShape);
                borders.put(name, border);
                Config.LogConfig(Config.BorderDescription(name));
            }
        }
        if ((storedFillTask = cfg.getNode("fillTask")) != null) {
            String worldName = storedFillTask.getString("world");
            int fillDistance = storedFillTask.getInt("fillDistance", 176);
            int chunksPerRun = storedFillTask.getInt("chunksPerRun", 5);
            int tickFrequency = storedFillTask.getInt("tickFrequency", 20);
            int fillX = storedFillTask.getInt("x", 0);
            int fillZ = storedFillTask.getInt("z", 0);
            int fillLength = storedFillTask.getInt("length", 0);
            int fillTotal = storedFillTask.getInt("total", 0);
            Config.RestoreFillTask(worldName, fillDistance, chunksPerRun, tickFrequency, fillX, fillZ, fillLength, fillTotal);
            Config.save(false);
        }
        if (logIt) {
            Config.LogConfig("Configuration loaded.");
        }
        if (cfgVersion < 3) {
            Config.save(false);
        }
    }

    public static void save(boolean logIt) {
        Config.save(logIt, false);
    }

    public static void save(boolean logIt, boolean storeFillTask) {
        if (cfg == null) {
            return;
        }
        cfg.setProperty("cfg-version", (Object)3);
        cfg.setProperty("message", (Object)message);
        cfg.setProperty("round-border", (Object)shapeRound);
        cfg.setProperty("debug-mode", (Object)DEBUG);
        cfg.setProperty("whoosh-effect", (Object)whooshEffect);
        cfg.setProperty("knock-back-dist", (Object)knockBack);
        cfg.setProperty("timer-delay-ticks", (Object)timerTicks);
        cfg.removeProperty("worlds");
        for (Map.Entry<String, BorderData> wdata : borders.entrySet()) {
            String name = wdata.getKey();
            BorderData bord = wdata.getValue();
            cfg.setProperty("worlds." + name.replace(".", "\u00a8") + ".x", (Object)bord.getX());
            cfg.setProperty("worlds." + name.replace(".", "\u00a8") + ".z", (Object)bord.getZ());
            cfg.setProperty("worlds." + name.replace(".", "\u00a8") + ".radius", (Object)bord.getRadius());
            if (bord.getShape() == null) continue;
            cfg.setProperty("worlds." + name.replace(".", "\u00a8") + ".shape-round", (Object)bord.getShape());
        }
        if (storeFillTask && fillTask != null && fillTask.valid()) {
            cfg.setProperty("fillTask.world", (Object)fillTask.refWorld());
            cfg.setProperty("fillTask.fillDistance", (Object)fillTask.refFillDistance());
            cfg.setProperty("fillTask.chunksPerRun", (Object)fillTask.refChunksPerRun());
            cfg.setProperty("fillTask.tickFrequency", (Object)fillTask.refTickFrequency());
            cfg.setProperty("fillTask.x", (Object)fillTask.refX());
            cfg.setProperty("fillTask.z", (Object)fillTask.refZ());
            cfg.setProperty("fillTask.length", (Object)fillTask.refLength());
            cfg.setProperty("fillTask.total", (Object)fillTask.refTotal());
        } else {
            cfg.removeProperty("fillTask");
        }
        cfg.save();
        if (logIt) {
            Config.LogConfig("Configuration saved.");
        }
    }

    static {
        cfg = null;
        Permissions = null;
        mcLog = Logger.getLogger("Minecraft");
        coord = new DecimalFormat("0.0");
        borderTask = -1;
        fillTask = null;
        trimTask = null;
        movedPlayers = Collections.synchronizedSet(new HashSet());
        rt = Runtime.getRuntime();
        shapeRound = true;
        borders = Collections.synchronizedMap(new LinkedHashMap());
        DEBUG = false;
        knockBack = 3.0;
        timerTicks = 4;
        whooshEffect = false;
    }
}

