/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.WorldBorder;
import com.wimbli.WorldBorder.WorldFillTask;
import com.wimbli.WorldBorder.WorldTrimTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WBCommand
implements CommandExecutor {
    private WorldBorder plugin;
    private final String clrCmd = ChatColor.AQUA.toString();
    private final String clrReq = ChatColor.GREEN.toString();
    private final String clrOpt = ChatColor.DARK_GREEN.toString();
    private final String clrDesc = ChatColor.WHITE.toString();
    private final String clrHead = ChatColor.YELLOW.toString();
    private final String clrErr = ChatColor.RED.toString();
    private String fillWorld = "";
    private int fillFrequency = 20;
    private int fillPadding = CoordXZ.chunkToBlock(11);
    private String trimWorld = "";
    private int trimFrequency = 5000;
    private int trimPadding = CoordXZ.chunkToBlock(12);

    public WBCommand(WorldBorder plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] split) {
        boolean pause;
        BorderData border;
        Object world;
        Player player = sender instanceof Player ? (Player)sender : null;
        String cmd = this.clrCmd + (player == null ? "wb" : "/wb");
        String cmdW = this.clrCmd + (player == null ? "wb " + this.clrReq + "<world>" : "/wb " + this.clrOpt + "[world]") + this.clrCmd;
        if (split.length > 2 && split[0].startsWith("\"")) {
            if (split[0].endsWith("\"")) {
                split[0] = split[0].substring(1, split[0].length() - 1);
            } else {
                int loop;
                ArrayList<String> args = new ArrayList<String>();
                String quote = split[0];
                for (loop = 1; loop < split.length; ++loop) {
                    quote = quote + " " + split[loop];
                    if (split[loop].endsWith("\"")) break;
                }
                if (loop < split.length || !split[loop].endsWith("\"")) {
                    args.add(quote.substring(1, quote.length() - 1));
                    ++loop;
                    while (loop < split.length) {
                        args.add(split[loop]);
                        ++loop;
                    }
                    split = args.toArray(new String[0]);
                }
            }
        }
        if (split.length == 5 && split[1].equalsIgnoreCase("set")) {
            if (!Config.HasPermission(player, "set")) {
                return true;
            }
            world = sender.getServer().getWorld(split[0]);
            if (world == null) {
                sender.sendMessage("The world you specified (\"" + split[0] + "\") could not be found on the server, but data for it will be stored anyway.");
            }
            if (this.cmdSet(sender, split[0], split, 2) && player != null) {
                sender.sendMessage("Border has been set. " + Config.BorderDescription(split[0]));
            }
        } else if (split.length == 4 && split[0].equalsIgnoreCase("set") && player != null) {
            if (!Config.HasPermission(player, "set")) {
                return true;
            }
            world = player.getWorld().getName();
            if (this.cmdSet(sender, (String)world, split, 1)) {
                sender.sendMessage("Border has been set. " + Config.BorderDescription((String)world));
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("set") && player != null) {
            int radius;
            if (!Config.HasPermission(player, "set")) {
                return true;
            }
            world = player.getWorld().getName();
            double x = player.getLocation().getX();
            double z = player.getLocation().getZ();
            try {
                radius = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(this.clrErr + "The radius value must be an integer.");
                return true;
            }
            Config.setBorder((String)world, radius, x, z);
            sender.sendMessage("Border has been set. " + Config.BorderDescription((String)world));
        } else if (split.length == 3 && split[1].equalsIgnoreCase("radius")) {
            int radius;
            if (!Config.HasPermission(player, "radius")) {
                return true;
            }
            world = split[0];
            border = Config.Border((String)world);
            if (border == null) {
                sender.sendMessage(this.clrErr + "That world (\"" + (String)world + "\") must first have a border set normally.");
                return true;
            }
            double x = border.getX();
            double z = border.getZ();
            try {
                radius = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(this.clrErr + "The radius value must be an integer.");
                return true;
            }
            Config.setBorder((String)world, radius, x, z);
            if (player != null) {
                sender.sendMessage("Radius has been set. " + Config.BorderDescription((String)world));
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("radius") && player != null) {
            int radius;
            if (!Config.HasPermission(player, "radius")) {
                return true;
            }
            world = player.getWorld().getName();
            border = Config.Border((String)world);
            if (border == null) {
                sender.sendMessage(this.clrErr + "This world (\"" + (String)world + "\") must first have a border set normally.");
                return true;
            }
            double x = border.getX();
            double z = border.getZ();
            try {
                radius = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(this.clrErr + "The radius value must be an integer.");
                return true;
            }
            Config.setBorder((String)world, radius, x, z);
            sender.sendMessage("Radius has been set. " + Config.BorderDescription((String)world));
        } else if (split.length == 2 && split[1].equalsIgnoreCase("clear")) {
            if (!Config.HasPermission(player, "clear")) {
                return true;
            }
            world = split[0];
            border = Config.Border((String)world);
            if (border == null) {
                sender.sendMessage("The world you specified (\"" + (String)world + "\") does not have a border set.");
                return true;
            }
            Config.removeBorder((String)world);
            if (player != null) {
                sender.sendMessage("Border cleared for world \"" + (String)world + "\".");
            }
        } else if (split.length == 1 && split[0].equalsIgnoreCase("clear") && player != null) {
            if (!Config.HasPermission(player, "clear")) {
                return true;
            }
            world = player.getWorld().getName();
            border = Config.Border((String)world);
            if (border == null) {
                sender.sendMessage(this.clrErr + "Your current world (\"" + (String)world + "\") does not have a border set.");
                return true;
            }
            Config.removeBorder((String)world);
            sender.sendMessage("Border cleared for world \"" + (String)world + "\".");
        } else if (split.length == 2 && split[0].equalsIgnoreCase("clear") && split[1].equalsIgnoreCase("all")) {
            if (!Config.HasPermission(player, "clear")) {
                return true;
            }
            Config.removeAllBorders();
            if (player != null) {
                sender.sendMessage("All borders cleared for all worlds.");
            }
        } else if (split.length == 1 && split[0].equalsIgnoreCase("list")) {
            if (!Config.HasPermission(player, "list")) {
                return true;
            }
            sender.sendMessage("Default border shape for all worlds is \"" + (Config.ShapeRound() ? "round" : "square") + "\".");
            Set<String> list = Config.BorderDescriptions();
            if (list.isEmpty()) {
                sender.sendMessage("There are no borders currently set.");
                return true;
            }
            Iterator<String> listItem = list.iterator();
            while (listItem.hasNext()) {
                sender.sendMessage(listItem.next());
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("shape")) {
            if (!Config.HasPermission(player, "shape")) {
                return true;
            }
            if (split[1].equalsIgnoreCase("square")) {
                Config.setShape(false);
            } else if (split[1].equalsIgnoreCase("round")) {
                Config.setShape(true);
            } else {
                sender.sendMessage("You must specify a shape of \"round\" or \"square\".");
                return true;
            }
            if (player != null) {
                sender.sendMessage("Default border shape for all worlds is now set to \"" + (Config.ShapeRound() ? "round" : "square") + "\".");
            }
        } else if (split.length == 1 && split[0].equalsIgnoreCase("getmsg")) {
            if (!Config.HasPermission(player, "getmsg")) {
                return true;
            }
            sender.sendMessage("Border message is currently set to:");
            sender.sendMessage(this.clrErr + Config.Message());
        } else if (split.length >= 2 && split[0].equalsIgnoreCase("setmsg")) {
            if (!Config.HasPermission(player, "setmsg")) {
                return true;
            }
            String message = "";
            for (int i = 1; i < split.length; ++i) {
                if (i != 1) {
                    message = message + ' ';
                }
                message = message + split[i];
            }
            Config.setMessage(message);
            if (player != null) {
                sender.sendMessage("Border message is now set to:");
                sender.sendMessage(this.clrErr + Config.Message());
            }
        } else if (split.length == 1 && split[0].equalsIgnoreCase("reload")) {
            if (!Config.HasPermission(player, "reload")) {
                return true;
            }
            if (player != null) {
                Config.Log("Reloading config file at the command of player \"" + player.getName() + "\".");
            }
            Config.load(this.plugin, true);
            if (player != null) {
                sender.sendMessage("WorldBorder configuration reloaded.");
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("debug")) {
            if (!Config.HasPermission(player, "debug")) {
                return true;
            }
            Config.setDebug(split[1].equalsIgnoreCase("on"));
            if (player != null) {
                Config.Log((Config.Debug() ? "Enabling" : "Disabling") + " debug output at the command of player \"" + player.getName() + "\".");
            }
            if (player != null) {
                sender.sendMessage("Debug mode " + (Config.Debug() ? "enabled" : "disabled") + ".");
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("whoosh")) {
            if (!Config.HasPermission(player, "whoosh")) {
                return true;
            }
            Config.setWhooshEffect(split[1].equalsIgnoreCase("on"));
            if (player != null) {
                Config.Log((Config.whooshEffect() ? "Enabling" : "Disabling") + " \"whoosh\" knockback effect at the command of player \"" + player.getName() + "\".");
            }
            if (player != null) {
                sender.sendMessage("\"Whoosh\" knockback effect " + (Config.whooshEffect() ? "enabled" : "disabled") + ".");
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("knockback")) {
            if (!Config.HasPermission(player, "knockback")) {
                return true;
            }
            double numBlocks = 0.0;
            try {
                numBlocks = Double.parseDouble(split[1]);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(this.clrErr + "The knockback must be a decimal value of at least 1.0.");
                return true;
            }
            if (numBlocks < 1.0) {
                sender.sendMessage(this.clrErr + "The knockback must be a decimal value of at least 1.0.");
                return true;
            }
            Config.setKnockBack(numBlocks);
            if (player != null) {
                sender.sendMessage("Knockback set to " + numBlocks + " blocks inside the border.");
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("delay")) {
            if (!Config.HasPermission(player, "delay")) {
                return true;
            }
            int delay = 0;
            try {
                delay = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(this.clrErr + "The timer delay must be an integer of 1 or higher.");
                return true;
            }
            if (delay < 1) {
                sender.sendMessage(this.clrErr + "The timer delay must be an integer of 1 or higher.");
                return true;
            }
            Config.setTimerTicks(delay);
            if (player != null) {
                sender.sendMessage("Timer delay set to " + delay + " tick(s). That is roughly " + delay * 50 + "ms.");
            }
        } else if (split.length == 3 && split[0].equalsIgnoreCase("wshape")) {
            if (!Config.HasPermission(player, "wshape")) {
                return true;
            }
            world = split[1];
            border = Config.Border((String)world);
            if (border == null) {
                sender.sendMessage("The world you specified (\"" + (String)world + "\") does not have a border set.");
                return true;
            }
            Boolean shape = null;
            if (split[2].equalsIgnoreCase("square")) {
                shape = false;
            } else if (split[2].equalsIgnoreCase("round")) {
                shape = true;
            }
            border.setShape(shape);
            Config.setBorder((String)world, border);
            if (player != null) {
                sender.sendMessage("Border shape for world \"" + (String)world + "\" is now set to \"" + (shape == null ? "default" : (shape != false ? "round" : "square")) + "\".");
            }
        } else if (split.length == 2 && split[0].equalsIgnoreCase("wshape") && player != null) {
            if (!Config.HasPermission(player, "wshape")) {
                return true;
            }
            world = player.getWorld().getName();
            border = Config.Border((String)world);
            if (border == null) {
                sender.sendMessage("This world (\"" + (String)world + "\") does not have a border set.");
                return true;
            }
            Boolean shape = null;
            if (split[1].equalsIgnoreCase("square")) {
                shape = false;
            } else if (split[1].equalsIgnoreCase("round")) {
                shape = true;
            }
            border.setShape(shape);
            Config.setBorder((String)world, border);
            sender.sendMessage("Border shape for world \"" + (String)world + "\" is now set to \"" + (shape == null ? "default" : (shape != false ? "round" : "square")) + "\".");
        } else if (split.length >= 2 && split[1].equalsIgnoreCase("fill")) {
            if (!Config.HasPermission(player, "fill")) {
                return true;
            }
            boolean cancel = false;
            boolean confirm = false;
            pause = false;
            String pad = "";
            String frequency = "";
            if (split.length >= 3) {
                cancel = split[2].equalsIgnoreCase("cancel");
                confirm = split[2].equalsIgnoreCase("confirm");
                pause = split[2].equalsIgnoreCase("pause");
                if (!(cancel || confirm || pause)) {
                    frequency = split[2];
                }
            }
            if (split.length >= 4) {
                pad = split[3];
            }
            String world2 = split[0];
            this.cmdFill(sender, player, world2, confirm, cancel, pause, pad, frequency);
        } else if (split.length >= 1 && split[0].equalsIgnoreCase("fill")) {
            if (!Config.HasPermission(player, "fill")) {
                return true;
            }
            boolean cancel = false;
            boolean confirm = false;
            pause = false;
            String pad = "";
            String frequency = "";
            if (split.length >= 2) {
                cancel = split[1].equalsIgnoreCase("cancel");
                confirm = split[1].equalsIgnoreCase("confirm");
                pause = split[1].equalsIgnoreCase("pause");
                if (!(cancel || confirm || pause)) {
                    frequency = split[1];
                }
            }
            if (split.length >= 3) {
                pad = split[2];
            }
            String world3 = "";
            if (player != null) {
                world3 = player.getWorld().getName();
            }
            if (!cancel && !confirm && !pause && world3.isEmpty()) {
                sender.sendMessage("You must specify a world! Example: " + cmdW + " fill " + this.clrOpt + "[freq] [pad]");
                return true;
            }
            this.cmdFill(sender, player, world3, confirm, cancel, pause, pad, frequency);
        } else if (split.length >= 2 && split[1].equalsIgnoreCase("trim")) {
            if (!Config.HasPermission(player, "trim")) {
                return true;
            }
            boolean cancel = false;
            boolean confirm = false;
            pause = false;
            String pad = "";
            String frequency = "";
            if (split.length >= 3) {
                cancel = split[2].equalsIgnoreCase("cancel");
                confirm = split[2].equalsIgnoreCase("confirm");
                pause = split[2].equalsIgnoreCase("pause");
                if (!(cancel || confirm || pause)) {
                    frequency = split[2];
                }
            }
            if (split.length >= 4) {
                pad = split[3];
            }
            String world4 = split[0];
            this.cmdTrim(sender, player, world4, confirm, cancel, pause, pad, frequency);
        } else if (split.length >= 1 && split[0].equalsIgnoreCase("trim")) {
            if (!Config.HasPermission(player, "trim")) {
                return true;
            }
            boolean cancel = false;
            boolean confirm = false;
            pause = false;
            String pad = "";
            String frequency = "";
            if (split.length >= 2) {
                cancel = split[1].equalsIgnoreCase("cancel");
                confirm = split[1].equalsIgnoreCase("confirm");
                pause = split[1].equalsIgnoreCase("pause");
                if (!(cancel || confirm || pause)) {
                    frequency = split[1];
                }
            }
            if (split.length >= 3) {
                pad = split[2];
            }
            String world5 = "";
            if (player != null) {
                world5 = player.getWorld().getName();
            }
            if (!cancel && !confirm && !pause && world5.isEmpty()) {
                sender.sendMessage("You must specify a world! Example: " + cmdW + " trim " + this.clrOpt + "[freq] [pad]");
                return true;
            }
            this.cmdTrim(sender, player, world5, confirm, cancel, pause, pad, frequency);
        } else {
            int page;
            if (!Config.HasPermission(player, "help")) {
                return true;
            }
            int n = page = player == null ? 0 : 1;
            if (split.length == 1) {
                try {
                    page = Integer.parseInt(split[0]);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                if (page > 2) {
                    page = 1;
                }
            }
            sender.sendMessage(this.clrHead + this.plugin.getDescription().getFullName() + " - commands (" + this.clrReq + "<required> " + this.clrOpt + "[optional]" + this.clrHead + ")" + (page > 0 ? " " + page + "/2" : "") + ":");
            if (page == 0 || page == 1) {
                if (player != null) {
                    sender.sendMessage(cmd + " set " + this.clrReq + "<radius>" + this.clrDesc + " - set world border, centered on you.");
                }
                sender.sendMessage(cmdW + " set " + this.clrReq + "<radius> <x> <z>" + this.clrDesc + " - set world border.");
                sender.sendMessage(cmdW + " radius " + this.clrReq + "<radius>" + this.clrDesc + " - change a border radius.");
                sender.sendMessage(cmdW + " clear" + this.clrDesc + " - remove border for this world.");
                sender.sendMessage(cmd + " clear all" + this.clrDesc + " - remove border for all worlds.");
                sender.sendMessage(cmd + " list" + this.clrDesc + " - show border information for all worlds.");
                sender.sendMessage(cmd + " shape " + this.clrReq + "<round|square>" + this.clrDesc + " - set the default border shape.");
                sender.sendMessage(cmd + " knockback " + this.clrReq + "<distance>" + this.clrDesc + " - how far to move the player back.");
                if (page == 1) {
                    sender.sendMessage(cmd + " 2" + this.clrDesc + " - view second page of commands.");
                }
            }
            if (page == 0 || page == 2) {
                sender.sendMessage(cmdW + " fill " + this.clrOpt + "[freq] [pad]" + this.clrDesc + " - generate world out to border.");
                sender.sendMessage(cmdW + " trim " + this.clrOpt + "[freq] [pad]" + this.clrDesc + " - trim world outside of border.");
                sender.sendMessage(cmd + " wshape " + (player == null ? this.clrReq + "<world>" : this.clrOpt + "[world]") + this.clrReq + " <round|square|default>" + this.clrDesc + " - shape override.");
                sender.sendMessage(cmd + " getmsg" + this.clrDesc + " - display border message.");
                sender.sendMessage(cmd + " setmsg " + this.clrReq + "<text>" + this.clrDesc + " - set border message.");
                sender.sendMessage(cmd + " whoosh " + this.clrReq + "<on|off>" + this.clrDesc + " - turn knockback effect on or off.");
                sender.sendMessage(cmd + " delay " + this.clrReq + "<amount>" + this.clrDesc + " - time between border checks.");
                sender.sendMessage(cmd + " reload" + this.clrDesc + " - re-load data from config.yml.");
                if (player == null) {
                    sender.sendMessage(cmd + " debug " + this.clrReq + "<on|off>" + this.clrDesc + " - turn console debug output on or off.");
                }
                if (page == 2) {
                    sender.sendMessage(cmd + this.clrDesc + " - view first page of commands.");
                }
            }
        }
        return true;
    }

    private boolean cmdSet(CommandSender sender, String world, String[] data, int offset) {
        double z;
        double x;
        int radius;
        try {
            radius = Integer.parseInt(data[offset]);
            x = Double.parseDouble(data[offset + 1]);
            z = Double.parseDouble(data[offset + 2]);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(this.clrErr + "The radius value must be an integer and the x and z values must be numerical.");
            return false;
        }
        Config.setBorder(world, radius, x, z);
        return true;
    }

    private void fillDefaults() {
        this.fillWorld = "";
        this.fillFrequency = 20;
        this.fillPadding = CoordXZ.chunkToBlock(11);
    }

    private boolean cmdFill(CommandSender sender, Player player, String world, boolean confirm, boolean cancel, boolean pause, String pad, String frequency) {
        if (cancel) {
            sender.sendMessage(this.clrHead + "Cancelling the world map generation task.");
            this.fillDefaults();
            Config.StopFillTask();
            return true;
        }
        if (pause) {
            if (Config.fillTask == null || !Config.fillTask.valid()) {
                sender.sendMessage(this.clrHead + "The world map generation task is not currently running.");
                return true;
            }
            Config.fillTask.pause();
            sender.sendMessage(this.clrHead + "The world map generation task is now " + (Config.fillTask.isPaused() ? "" : "un") + "paused.");
            return true;
        }
        if (Config.fillTask != null && Config.fillTask.valid()) {
            sender.sendMessage(this.clrHead + "The world map generation task is already running.");
            return true;
        }
        try {
            if (!pad.isEmpty()) {
                this.fillPadding = Math.abs(Integer.parseInt(pad));
            }
            if (!frequency.isEmpty()) {
                this.fillFrequency = Math.abs(Integer.parseInt(frequency));
            }
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(this.clrErr + "The frequency and padding values must be integers.");
            return false;
        }
        if (!world.isEmpty()) {
            this.fillWorld = world;
        }
        if (confirm) {
            if (this.fillWorld.isEmpty()) {
                sender.sendMessage(this.clrErr + "You must first use this command successfully without confirming.");
                return false;
            }
            if (player != null) {
                Config.Log("Filling out world to border at the command of player \"" + player.getName() + "\".");
            }
            int ticks = 1;
            int repeats = 1;
            if (this.fillFrequency > 20) {
                repeats = this.fillFrequency / 20;
            } else {
                ticks = 20 / this.fillFrequency;
            }
            Config.fillTask = new WorldFillTask(this.plugin.getServer(), player, this.fillWorld, this.fillPadding, repeats, ticks);
            if (Config.fillTask.valid()) {
                int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)Config.fillTask, (long)ticks, (long)ticks);
                Config.fillTask.setTaskID(task);
                sender.sendMessage("WorldBorder map generation task started.");
            } else {
                sender.sendMessage(this.clrErr + "The world map generation task failed to start.");
            }
            this.fillDefaults();
        } else {
            if (this.fillWorld.isEmpty()) {
                sender.sendMessage(this.clrErr + "You must first specify a valid world.");
                return false;
            }
            String cmd = this.clrCmd + (player == null ? "wb" : "/wb");
            sender.sendMessage(this.clrHead + "World generation task is ready for world \"" + this.fillWorld + "\", padding the map out to " + this.fillPadding + " blocks beyond the border (default " + CoordXZ.chunkToBlock(11) + "), and the task will try to process up to " + this.fillFrequency + " chunks per second (default 20).");
            sender.sendMessage(this.clrHead + "This process can take a very long time depending on the world's border size. Also, depending on the chunk processing rate, players will likely experience severe lag for the duration.");
            sender.sendMessage(this.clrDesc + "You should now use " + cmd + " fill confirm" + this.clrDesc + " to start the process.");
            sender.sendMessage(this.clrDesc + "You can cancel at any time with " + cmd + " fill cancel" + this.clrDesc + ", or pause/unpause with " + cmd + " fill pause" + this.clrDesc + ".");
        }
        return true;
    }

    private void trimDefaults() {
        this.trimWorld = "";
        this.trimFrequency = 5000;
        this.trimPadding = CoordXZ.chunkToBlock(12);
    }

    private boolean cmdTrim(CommandSender sender, Player player, String world, boolean confirm, boolean cancel, boolean pause, String pad, String frequency) {
        if (cancel) {
            sender.sendMessage(this.clrHead + "Cancelling the world map trimming task.");
            this.trimDefaults();
            Config.StopTrimTask();
            return true;
        }
        if (pause) {
            if (Config.trimTask == null || !Config.trimTask.valid()) {
                sender.sendMessage(this.clrHead + "The world map trimming task is not currently running.");
                return true;
            }
            Config.trimTask.pause();
            sender.sendMessage(this.clrHead + "The world map trimming task is now " + (Config.trimTask.isPaused() ? "" : "un") + "paused.");
            return true;
        }
        if (Config.trimTask != null && Config.trimTask.valid()) {
            sender.sendMessage(this.clrHead + "The world map trimming task is already running.");
            return true;
        }
        try {
            if (!pad.isEmpty()) {
                this.trimPadding = Math.abs(Integer.parseInt(pad));
            }
            if (!frequency.isEmpty()) {
                this.trimFrequency = Math.abs(Integer.parseInt(frequency));
            }
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(this.clrErr + "The frequency and padding values must be integers.");
            return false;
        }
        if (!world.isEmpty()) {
            this.trimWorld = world;
        }
        if (confirm) {
            if (this.trimWorld.isEmpty()) {
                sender.sendMessage(this.clrErr + "You must first use this command successfully without confirming.");
                return false;
            }
            if (player != null) {
                Config.Log("Trimming world beyond border at the command of player \"" + player.getName() + "\".");
            }
            int ticks = 1;
            int repeats = 1;
            if (this.trimFrequency > 20) {
                repeats = this.trimFrequency / 20;
            } else {
                ticks = 20 / this.trimFrequency;
            }
            Config.trimTask = new WorldTrimTask(this.plugin.getServer(), player, this.trimWorld, this.trimPadding, repeats);
            if (Config.trimTask.valid()) {
                int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)Config.trimTask, (long)ticks, (long)ticks);
                Config.trimTask.setTaskID(task);
                sender.sendMessage("WorldBorder map trimming task started.");
            } else {
                sender.sendMessage(this.clrErr + "The world map trimming task failed to start.");
            }
            this.trimDefaults();
        } else {
            if (this.trimWorld.isEmpty()) {
                sender.sendMessage(this.clrErr + "You must first specify a valid world.");
                return false;
            }
            String cmd = this.clrCmd + (player == null ? "wb" : "/wb");
            sender.sendMessage(this.clrHead + "World trimming task is ready for world \"" + this.trimWorld + "\", trimming the map past " + this.trimPadding + " blocks beyond the border (default " + CoordXZ.chunkToBlock(12) + "), and the task will try to process up to " + this.trimFrequency + " chunks per second (default 5000).");
            sender.sendMessage(this.clrHead + "This process can take a while depending on the world's overall size. Also, depending on the chunk processing rate, players may experience lag for the duration.");
            sender.sendMessage(this.clrDesc + "You should now use " + cmd + " trim confirm" + this.clrDesc + " to start the process.");
            sender.sendMessage(this.clrDesc + "You can cancel at any time with " + cmd + " trim cancel" + this.clrDesc + ", or pause/unpause with " + cmd + " trim pause" + this.clrDesc + ".");
        }
        return true;
    }
}

