/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldTrimTask
implements Runnable {
    private transient Server server = null;
    private transient World world = null;
    private transient File regionFolder = null;
    private transient File[] regionFiles = null;
    private transient BorderData border = null;
    private transient boolean readyToGo = false;
    private transient boolean paused = false;
    private transient int taskID = -1;
    private transient Player notifyPlayer = null;
    private transient int chunksPerRun = 1;
    private transient int currentRegion = -1;
    private transient int regionX = 0;
    private transient int regionZ = 0;
    private transient int currentChunk = 0;
    private transient List<CoordXZ> regionChunks = new ArrayList<CoordXZ>(1024);
    private transient List<CoordXZ> trimChunks = new ArrayList<CoordXZ>(1024);
    private transient int counter = 0;
    private transient long lastReport = Config.Now();
    private transient int reportTarget = 0;
    private transient int reportTotal = 0;
    private transient int reportTrimmedRegions = 0;
    private transient int reportTrimmedChunks = 0;

    public WorldTrimTask(Server theServer, Player player, String worldName, int trimDistance, int chunksPerRun) {
        this.server = theServer;
        this.notifyPlayer = player;
        this.chunksPerRun = chunksPerRun;
        this.world = this.server.getWorld(worldName);
        if (this.world == null) {
            if (worldName.isEmpty()) {
                this.sendMessage("You must specify a world!");
            } else {
                this.sendMessage("World \"" + worldName + "\" not found!");
            }
            this.stop();
            return;
        }
        BorderData borderData = this.border = Config.Border(worldName) == null ? null : Config.Border(worldName).copy();
        if (this.border == null) {
            this.sendMessage("No border found for world \"" + worldName + "\"!");
            this.stop();
            return;
        }
        this.border.setRadius(this.border.getRadius() + trimDistance);
        this.regionFolder = new File("./" + worldName + "/region");
        if (!this.regionFolder.exists() || !this.regionFolder.isDirectory()) {
            String mainRegionFolder = this.regionFolder.getPath();
            this.regionFolder = new File("./" + worldName + "/DIM-1/region");
            if (!this.regionFolder.exists() || !this.regionFolder.isDirectory()) {
                this.sendMessage("Could not validate folder for world's region files. Looked in: " + mainRegionFolder + " -and- " + this.regionFolder.getPath());
                this.stop();
                return;
            }
        }
        this.regionFiles = this.regionFolder.listFiles(new RegionFileFilter());
        if (this.regionFiles == null || this.regionFiles.length == 0) {
            this.sendMessage("Could not find any region files. Looked in: " + this.regionFolder.getPath());
            this.stop();
            return;
        }
        this.reportTarget = this.regionFiles.length * 3072;
        if (!this.nextFile()) {
            return;
        }
        this.readyToGo = true;
    }

    public void setTaskID(int ID) {
        this.taskID = ID;
    }

    public void run() {
        if (this.server == null || !this.readyToGo || this.paused) {
            return;
        }
        this.readyToGo = false;
        this.counter = 0;
        while (this.counter <= this.chunksPerRun) {
            if (this.paused) {
                return;
            }
            if (Config.Now() > this.lastReport + 5000L) {
                this.reportProgress();
            }
            if (this.regionChunks.isEmpty()) {
                this.addCornerChunks();
            } else if (this.currentChunk == 4) {
                if (this.trimChunks.isEmpty()) {
                    this.counter += 4;
                    this.nextFile();
                    continue;
                }
                this.addEdgeChunks();
                this.addInnerChunks();
            } else {
                if (this.currentChunk == 124 && this.trimChunks.size() == 124) {
                    this.counter += 16;
                    this.trimChunks = this.regionChunks;
                    this.unloadChunks();
                    ++this.reportTrimmedRegions;
                    if (!this.regionFiles[this.currentRegion].delete()) {
                        this.sendMessage("Error! Region file which is outside the border could not be deleted: " + this.regionFiles[this.currentRegion].getName());
                        this.wipeChunks();
                    }
                    this.nextFile();
                    continue;
                }
                if (this.currentChunk == 1024) {
                    this.counter += 32;
                    this.unloadChunks();
                    this.wipeChunks();
                    this.nextFile();
                    continue;
                }
            }
            CoordXZ chunk = this.regionChunks.get(this.currentChunk);
            if (!this.isChunkInsideBorder(chunk)) {
                this.trimChunks.add(chunk);
            }
            ++this.currentChunk;
            ++this.counter;
        }
        this.reportTotal += this.counter;
        this.readyToGo = true;
    }

    private boolean nextFile() {
        this.reportTotal = this.currentRegion * 3072;
        ++this.currentRegion;
        this.currentChunk = 0;
        this.regionZ = 0;
        this.regionX = 0;
        this.regionChunks = new ArrayList<CoordXZ>(1024);
        this.trimChunks = new ArrayList<CoordXZ>(1024);
        if (this.currentRegion >= this.regionFiles.length) {
            this.paused = true;
            this.readyToGo = false;
            this.finish();
            return false;
        }
        this.counter += 16;
        String[] coords = this.regionFiles[this.currentRegion].getName().split("\\.");
        try {
            this.regionX = Integer.parseInt(coords[1]);
            this.regionZ = Integer.parseInt(coords[2]);
        }
        catch (Exception ex) {
            this.sendMessage("Error! Region file found with abnormal name: " + this.regionFiles[this.currentRegion].getName());
            return false;
        }
        return true;
    }

    private void addCornerChunks() {
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX), CoordXZ.regionToChunk(this.regionZ)));
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + 31, CoordXZ.regionToChunk(this.regionZ)));
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX), CoordXZ.regionToChunk(this.regionZ) + 31));
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + 31, CoordXZ.regionToChunk(this.regionZ) + 31));
    }

    private void addEdgeChunks() {
        int chunkZ;
        int chunkX = 0;
        for (chunkZ = 1; chunkZ < 31; ++chunkZ) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        chunkX = 31;
        for (chunkZ = 1; chunkZ < 31; ++chunkZ) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        chunkZ = 0;
        for (chunkX = 1; chunkX < 31; ++chunkX) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        chunkZ = 31;
        for (chunkX = 1; chunkX < 31; ++chunkX) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        this.counter += 4;
    }

    private void addInnerChunks() {
        for (int chunkX = 1; chunkX < 31; ++chunkX) {
            for (int chunkZ = 1; chunkZ < 31; ++chunkZ) {
                this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
            }
        }
        this.counter += 32;
    }

    private void unloadChunks() {
        for (CoordXZ unload : this.trimChunks) {
            this.world.unloadChunk(unload.x, unload.z, false, false);
        }
        this.counter += this.trimChunks.size();
    }

    private void wipeChunks() {
        if (!this.regionFiles[this.currentRegion].canWrite()) {
            this.regionFiles[this.currentRegion].setWritable(true);
            if (!this.regionFiles[this.currentRegion].canWrite()) {
                this.sendMessage("Error! region file is locked and can't be trimmed: " + this.regionFiles[this.currentRegion].getName());
                return;
            }
        }
        int offsetX = CoordXZ.regionToChunk(this.regionX);
        int offsetZ = CoordXZ.regionToChunk(this.regionZ);
        long wipePos = 0L;
        try {
            RandomAccessFile unChunk = new RandomAccessFile(this.regionFiles[this.currentRegion], "rwd");
            for (CoordXZ wipe : this.trimChunks) {
                wipePos = 4 * (wipe.x - offsetX + (wipe.z - offsetZ) * 32);
                unChunk.seek(wipePos);
                unChunk.writeInt(0);
            }
            unChunk.close();
            this.reportTrimmedChunks += this.trimChunks.size();
        }
        catch (FileNotFoundException ex) {
            this.sendMessage("Error! Could not open region file to wipe individual chunks: " + this.regionFiles[this.currentRegion].getName());
        }
        catch (IOException ex) {
            this.sendMessage("Error! Could not modify region file to wipe individual chunks: " + this.regionFiles[this.currentRegion].getName());
        }
        this.counter += this.trimChunks.size();
    }

    private boolean isChunkInsideBorder(CoordXZ chunk) {
        return this.border.insideBorder(CoordXZ.chunkToBlock(chunk.x) + 8, CoordXZ.chunkToBlock(chunk.z) + 8);
    }

    public void finish() {
        this.reportTotal = this.reportTarget;
        this.reportProgress();
        this.sendMessage("task successfully completed!");
        this.stop();
    }

    public void cancel() {
        this.stop();
    }

    private void stop() {
        if (this.server == null) {
            return;
        }
        this.readyToGo = false;
        if (this.taskID != -1) {
            this.server.getScheduler().cancelTask(this.taskID);
        }
        this.server = null;
    }

    public boolean valid() {
        return this.server != null;
    }

    public void pause() {
        this.pause(!this.paused);
    }

    public void pause(boolean pause) {
        this.paused = pause;
        if (pause) {
            this.reportProgress();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    private void reportProgress() {
        this.lastReport = Config.Now();
        double perc = (double)this.reportTotal / (double)this.reportTarget * 100.0;
        this.sendMessage(this.reportTrimmedRegions + " entire region(s) and " + this.reportTrimmedChunks + " individual chunk(s) trimmed so far (" + ChatColor.GREEN.toString() + Config.coord.format(perc) + "% done" + ChatColor.WHITE.toString() + ")");
    }

    private void sendMessage(String text) {
        Config.Log("[Trim] " + text);
        if (this.notifyPlayer != null) {
            this.notifyPlayer.sendMessage("[Trim] " + text);
        }
    }

    private static class RegionFileFilter
    implements FileFilter {
        private RegionFileFilter() {
        }

        public boolean accept(File file) {
            return file.exists() && file.isFile() && file.getName().toLowerCase().endsWith(".mcr");
        }
    }
}

